<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // إضافة عمود الشركة إذا لم يكن موجودًا
            if (!Schema::hasColumn('users', 'company_id')) {
                $table->foreignId('company_id')->nullable()->constrained()->onDelete('cascade');
            }

            // إضافة عمود الفرع إذا لم يكن موجودًا
            if (!Schema::hasColumn('users', 'branch_id')) {
                $table->foreignId('branch_id')->nullable()->constrained()->onDelete('cascade');
            }

            // إضافة عمود الهاتف إذا لم يكن موجودًا
            if (!Schema::hasColumn('users', 'phone')) {
                $table->string('phone')->nullable();
            }

            // إضافة عمود المنصب/الوظيفة
            if (!Schema::hasColumn('users', 'position')) {
                $table->string('position')->nullable();
            }

            // إضافة عمود حالة النشاط إذا لم يكن موجودًا
            if (!Schema::hasColumn('users', 'is_active')) {
                $table->boolean('is_active')->default(true);
            }

            // إضافة عمود آخر تسجيل دخول إذا لم يكن موجودًا
            if (!Schema::hasColumn('users', 'last_login_at')) {
                $table->timestamp('last_login_at')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            // حذف الأعمدة بالترتيب العكسي لتجنب مشاكل القيود الخارجية
            $columns = [
                'last_login_at',
                'is_active',
                'position',
                'phone'
            ];

            // حذف الأعمدة الموجودة فقط
            $existingColumns = [];
            foreach ($columns as $column) {
                if (Schema::hasColumn('users', $column)) {
                    $existingColumns[] = $column;
                }
            }

            if (!empty($existingColumns)) {
                $table->dropColumn($existingColumns);
            }

            // حذف القيود الخارجية والأعمدة المرتبطة بها
            if (Schema::hasColumn('users', 'branch_id')) {
                $table->dropForeign(['branch_id']);
                $table->dropColumn('branch_id');
            }

            if (Schema::hasColumn('users', 'company_id')) {
                $table->dropForeign(['company_id']);
                $table->dropColumn('company_id');
            }
        });
    }
};
