<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Role;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Check if the permission already exists
        $existingPermission = Permission::where('slug', 'create_users')->first();

        if (!$existingPermission) {
            // Find the parent permission for users management
            $parentPermission = Permission::where('slug', 'manage_users')->first();

            if ($parentPermission) {
                // Create the new permission
                $permission = Permission::create([
                    'parent_id' => $parentPermission->id,
                    'name' => 'إضافة مستخدمين',
                    'slug' => 'create_users',
                    'group' => 'users',
                    'description' => 'إضافة مستخدمين جدد',
                    'level' => 1,
                    'path' => $parentPermission->path . '.0', // Temporary path
                    'type' => 'action',
                    'resource' => 'users',
                    'order' => 2,
                    'is_active' => true,
                ]);

                // Update the path with the correct ID
                $permission->path = $parentPermission->path . '.' . $permission->id;
                $permission->save();

                // Assign this permission to the admin role
                $adminRole = Role::where('slug', 'admin')->first();
                if ($adminRole) {
                    $adminRole->permissions()->syncWithoutDetaching([$permission->id]);
                }
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Find and delete the permission
        $permission = Permission::where('slug', 'create_users')->first();
        if ($permission) {
            $permission->delete();
        }
    }
};
