<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('maintenance_contracts', function (Blueprint $table) {
            // نتحقق إذا كان العمود موجود بالفعل
            if (!Schema::hasColumn('maintenance_contracts', 'user_id')) {
                $table->foreignId('user_id')->nullable()->after('customer_id')->constrained()->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('maintenance_contracts', function (Blueprint $table) {
            if (Schema::hasColumn('maintenance_contracts', 'user_id')) {
                $table->dropForeign(['user_id']);
                $table->dropColumn('user_id');
            }
        });
    }
};
