<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectTaskDependenciesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_task_dependencies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('task_id')->constrained('project_tasks')->onDelete('cascade');
            $table->foreignId('dependency_task_id')->constrained('project_tasks', 'id')->onDelete('cascade');
            $table->enum('dependency_type', ['finish_to_start', 'start_to_start', 'finish_to_finish', 'start_to_finish'])->default('finish_to_start');
            $table->integer('lag_days')->default(0);
            $table->timestamps();

            // Ensure no duplicate dependencies
            $table->unique(['task_id', 'dependency_task_id'], 'project_task_dependencies_unique');
        });

        // Add is_critical_path column to project_tasks table
        Schema::table('project_tasks', function (Blueprint $table) {
            $table->boolean('is_critical_path')->default(false)->after('completion_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_task_dependencies');

        // Remove is_critical_path column from project_tasks table
        Schema::table('project_tasks', function (Blueprint $table) {
            $table->dropColumn('is_critical_path');
        });
    }
}
