<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectResourcesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_resources', function (Blueprint $table) {
            $table->id();
            $table->foreignId('installation_project_id')->constrained('installation_projects')->onDelete('cascade');
            $table->string('name');
            $table->enum('type', ['human', 'material', 'equipment', 'other']);
            $table->text('description')->nullable();
            $table->string('unit', 50);
            $table->decimal('cost_per_unit', 15, 2);
            $table->decimal('available_units', 15, 2);
            $table->decimal('allocated_units', 15, 2)->default(0);
            $table->string('supplier')->nullable();
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_resources');
    }
}
