<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProjectRisksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('project_risks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('installation_project_id')->constrained('installation_projects')->onDelete('cascade');
            $table->string('title');
            $table->text('description');
            $table->enum('category', ['technical', 'schedule', 'resource', 'cost', 'quality', 'safety', 'other']);
            $table->integer('probability')->comment('1-5 scale');
            $table->integer('severity')->comment('1-5 scale');
            $table->integer('risk_score')->comment('probability * severity');
            $table->enum('status', ['identified', 'analyzed', 'planned', 'monitored', 'resolved', 'closed'])->default('identified');
            $table->date('identified_date');
            $table->foreignId('responsible_user_id')->nullable()->constrained('users');
            $table->text('mitigation_strategy')->nullable();
            $table->text('contingency_plan')->nullable();
            $table->date('resolution_date')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('project_risks');
    }
}
