<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_valuations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('item_id')->constrained('inventory_items')->onDelete('cascade');
            $table->foreignId('warehouse_id')->constrained()->onDelete('cascade');
            $table->date('valuation_date');
            $table->decimal('quantity', 15, 5);
            $table->decimal('unit_cost', 15, 5);
            $table->decimal('total_cost', 15, 5);
            $table->enum('valuation_method', ['fifo', 'lifo', 'average']);
            $table->string('reference_type')->nullable();
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();

            // فهارس للبحث السريع
            $table->index(['company_id', 'item_id']);
            $table->index(['company_id', 'warehouse_id']);
            $table->index('valuation_date');
            $table->index('valuation_method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_valuations');
    }
};
