<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * تنفيذ الهجرة لإنشاء جدول سجل تسجيل الدخول
     *
     * @return void
     */
    public function up()
    {
        // تخطي إنشاء الجدول إذا كان موجودًا بالفعل
        if (Schema::hasTable('login_history')) {
            return;
        }

        Schema::create('login_history', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // نوع تسجيل الدخول (عادي، مصادقة ثنائية، إلخ)
            $table->string('login_type')->default('standard');

            // حالة تسجيل الدخول (نجاح، فشل)
            $table->string('status');

            // سبب الفشل (إن وجد)
            $table->string('failure_reason')->nullable();

            // عنوان IP
            $table->string('ip_address')->nullable();

            // معلومات المتصفح والجهاز
            $table->string('user_agent')->nullable();

            // الموقع الجغرافي (إن أمكن)
            $table->string('location')->nullable();

            // معلومات الجهاز
            $table->string('device')->nullable();

            // نظام التشغيل
            $table->string('operating_system')->nullable();

            // المتصفح
            $table->string('browser')->nullable();

            // وقت تسجيل الدخول
            $table->timestamp('login_at');

            // وقت تسجيل الخروج (إن وجد)
            $table->timestamp('logout_at')->nullable();

            $table->timestamps();

            // فهارس للبحث السريع
            $table->index(['user_id', 'status']);
            $table->index('login_at');
            $table->index('ip_address');
        });
    }

    /**
     * عكس الهجرة
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('login_history');
    }
};
