<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * تنفيذ الهجرة لإنشاء جدول سجل النشاطات
     *
     * @return void
     */
    public function up()
    {
        // تخطي إنشاء الجدول إذا كان موجودًا بالفعل
        if (Schema::hasTable('activity_logs')) {
            return;
        }

        Schema::create('activity_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('company_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('branch_id')->nullable()->constrained()->nullOnDelete();

            // نوع النشاط (تسجيل دخول، إنشاء، تحديث، حذف، إلخ)
            $table->string('action');

            // وصف النشاط
            $table->text('description')->nullable();

            // نوع الكائن المتأثر (مستخدم، عميل، مصعد، إلخ)
            $table->string('subject_type')->nullable();

            // معرف الكائن المتأثر
            $table->unsignedBigInteger('subject_id')->nullable();

            // البيانات قبل التغيير (JSON)
            $table->json('old_values')->nullable();

            // البيانات بعد التغيير (JSON)
            $table->json('new_values')->nullable();

            // عنوان IP للمستخدم
            $table->string('ip_address')->nullable();

            // معلومات المتصفح والجهاز
            $table->string('user_agent')->nullable();

            // الرابط الذي تم منه النشاط
            $table->string('url')->nullable();

            // الطريقة المستخدمة (GET, POST, PUT, DELETE)
            $table->string('method')->nullable();

            // مستوى الأهمية (info, warning, error, critical)
            $table->string('level')->default('info');

            // وقت حدوث النشاط
            $table->timestamps();

            // فهارس للبحث السريع
            $table->index(['user_id', 'action']);
            $table->index(['subject_type', 'subject_id']);
            $table->index(['company_id', 'branch_id']);
            $table->index('created_at');
            $table->index('level');
        });
    }

    /**
     * عكس الهجرة
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_logs');
    }
};
