<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * تنفيذ الهجرة لإنشاء جدول الصلاحيات المباشرة للمستخدمين
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_permission', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('permission_id')->constrained()->onDelete('cascade');

            // إضافة حقل للإشارة إلى ما إذا كان هذا الإذن ممنوحًا أو محظورًا
            // true = ممنوح، false = محظور (لتجاوز الصلاحيات من الأدوار)
            $table->boolean('granted')->default(true);

            // إضافة حقل للإشارة إلى مصدر الصلاحية (مباشر، وراثة، إلخ)
            $table->string('source')->default('direct');

            // إضافة حقل لتاريخ انتهاء الصلاحية (للصلاحيات المؤقتة)
            $table->timestamp('expires_at')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->unique(['user_id', 'permission_id']);
            $table->index(['user_id', 'granted']);
        });
    }

    /**
     * عكس الهجرة
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_permission');
    }
};
