<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * تنفيذ الهجرة لتحديث جدول الصلاحيات لدعم المستويات المتعددة
     *
     * @return void
     */
    public function up()
    {
        Schema::table('permissions', function (Blueprint $table) {
            // نتحقق من وجود الأعمدة قبل إضافتها
            if (!Schema::hasColumn('permissions', 'level')) {
                $table->integer('level')->default(0)->after('group');
            }

            if (!Schema::hasColumn('permissions', 'path')) {
                $table->string('path')->nullable()->after('level');
            }

            if (!Schema::hasColumn('permissions', 'resource')) {
                $table->string('resource')->nullable()->after('type');
            }

            if (!Schema::hasColumn('permissions', 'order')) {
                $table->integer('order')->default(0)->after('resource');
            }

            // إضافة فهرس للبحث السريع - نتخطى هذه الخطوة لتجنب الأخطاء
            // الفهرس سيتم إضافته في هجرة منفصلة إذا لزم الأمر
            // try {
            //     $table->index(['parent_id', 'level', 'is_active'], 'permissions_parent_level_active_index');
            // } catch (\Exception $e) {
            //     // الفهرس موجود بالفعل، نتجاهل الخطأ
            // }
        });
    }

    /**
     * عكس الهجرة
     *
     * @return void
     */
    public function down()
    {
        Schema::table('permissions', function (Blueprint $table) {
            // محاولة حذف الفهرس - نتخطى هذه الخطوة لتجنب الأخطاء
            // try {
            //     $table->dropIndex('permissions_parent_level_active_index');
            // } catch (\Exception $e) {
            //     // الفهرس غير موجود، نتجاهل الخطأ
            // }

            $columns = [];

            if (Schema::hasColumn('permissions', 'level')) {
                $columns[] = 'level';
            }

            if (Schema::hasColumn('permissions', 'path')) {
                $columns[] = 'path';
            }

            if (Schema::hasColumn('permissions', 'resource')) {
                $columns[] = 'resource';
            }

            if (Schema::hasColumn('permissions', 'order')) {
                $columns[] = 'order';
            }

            if (!empty($columns)) {
                $table->dropColumn($columns);
            }
        });
    }
};
