<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Only run if the companies table exists
        if (Schema::hasTable('companies')) {
            Schema::table('companies', function (Blueprint $table) {
                // Add fields if they don't exist
                if (!Schema::hasColumn('companies', 'name_en')) {
                    $table->string('name_en')->nullable()->after('name');
                }

                if (!Schema::hasColumn('companies', 'cr_number')) {
                    $table->string('cr_number')->nullable()->comment('Commercial Registration Number')->after('name_en');
                }

                if (!Schema::hasColumn('companies', 'vat_number')) {
                    $table->string('vat_number')->nullable()->comment('VAT Registration Number')->after('cr_number');
                }

                if (!Schema::hasColumn('companies', 'mobile')) {
                    $table->string('mobile')->nullable()->after('phone');
                }

                if (!Schema::hasColumn('companies', 'website')) {
                    $table->string('website')->nullable()->after('mobile');
                }

                if (!Schema::hasColumn('companies', 'address_en')) {
                    $table->text('address_en')->nullable()->after('address');
                }

                if (!Schema::hasColumn('companies', 'subscription_plan')) {
                    $table->string('subscription_plan')->default('basic')->after('is_active');
                }

                if (!Schema::hasColumn('companies', 'subscription_ends_at')) {
                    $table->timestamp('subscription_ends_at')->nullable()->after('subscription_plan');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Only run if the companies table exists
        if (Schema::hasTable('companies')) {
            Schema::table('companies', function (Blueprint $table) {
                // Drop the columns if they exist
                $columns = [
                    'name_en',
                    'cr_number',
                    'vat_number',
                    'mobile',
                    'website',
                    'address_en',
                    'subscription_plan',
                    'subscription_ends_at'
                ];

                foreach ($columns as $column) {
                    if (Schema::hasColumn('companies', $column)) {
                        $table->dropColumn($column);
                    }
                }
            });
        }
    }
};
