<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use App\Models\CashRegister;
use Illuminate\Support\Facades\DB;

// استخدام معرف الشركة الصحيح
$companyId = 1; // من الاستعلام السابق، معرف الشركة هو 1
echo "معرف الشركة: " . $companyId . "\n";

// إنشاء خزينة اختبار باستخدام النموذج
try {
    $register = new CashRegister();
    $register->name = 'خزينة اختبار';
    $register->code = 'TEST' . time();
    $register->description = 'خزينة اختبار تم إنشاؤها برمجيًا';
    $register->company_id = $companyId;
    $register->initial_balance = 1000;
    $register->current_balance = 1000;
    $register->currency = 'SAR';
    $register->is_active = true;
    $register->is_main = false;
    $register->save();

    echo "تم إنشاء الخزينة بنجاح باستخدام النموذج.\n";
    echo "معرف الخزينة: " . $register->id . "\n";
    echo "is_active: " . var_export($register->is_active, true) . " (نوع: " . gettype($register->is_active) . ")\n";
    echo "is_main: " . var_export($register->is_main, true) . " (نوع: " . gettype($register->is_main) . ")\n";
} catch (Exception $e) {
    echo "حدث خطأ أثناء إنشاء الخزينة باستخدام النموذج: " . $e->getMessage() . "\n";
}

// إنشاء خزينة اختبار باستخدام استعلام مباشر
try {
    $id = DB::table('cash_registers')->insertGetId([
        'name' => 'خزينة اختبار 2',
        'code' => 'TEST2' . time(),
        'description' => 'خزينة اختبار تم إنشاؤها برمجيًا باستخدام استعلام مباشر',
        'company_id' => $companyId,
        'initial_balance' => 2000,
        'current_balance' => 2000,
        'currency' => 'SAR',
        'is_active' => true,
        'is_main' => false,
        'created_at' => now(),
        'updated_at' => now(),
    ]);

    echo "\nتم إنشاء الخزينة بنجاح باستخدام استعلام مباشر.\n";
    echo "معرف الخزينة: " . $id . "\n";

    // استرجاع الخزينة للتحقق من القيم
    $register = DB::table('cash_registers')->find($id);
    echo "is_active: " . var_export($register->is_active, true) . " (نوع: " . gettype($register->is_active) . ")\n";
    echo "is_main: " . var_export($register->is_main, true) . " (نوع: " . gettype($register->is_main) . ")\n";
} catch (Exception $e) {
    echo "حدث خطأ أثناء إنشاء الخزينة باستخدام استعلام مباشر: " . $e->getMessage() . "\n";
}

// التحقق من جميع الخزائن
$registers = DB::table('cash_registers')->select('id', 'name', 'is_active', 'is_main')->get();
echo "\nجميع الخزائن:\n";
foreach ($registers as $register) {
    echo "- ID: " . $register->id . ", الاسم: " . $register->name .
        ", is_active: " . var_export($register->is_active, true) .
        ", is_main: " . var_export($register->is_main, true) . "\n";

    // عرض نوع البيانات
    echo "  نوع is_active: " . gettype($register->is_active) .
        ", نوع is_main: " . gettype($register->is_main) . "\n";
}
