<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Notification;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

// حذف الإشعارات الحالية للاختبار
DB::table('notifications')->truncate();
echo "تم حذف الإشعارات الحالية.\n";

// الحصول على المستخدمين
$users = User::all();

if ($users->isEmpty()) {
    echo "لا يوجد مستخدمين في النظام. سيتم إنشاء مستخدم تجريبي.\n";

    // إنشاء مستخدم تجريبي
    $user = new User();
    $user->name = 'مستخدم تجريبي';
    $user->email = 'test@example.com';
    $user->password = bcrypt('password');
    $user->company_id = 1;
    $user->save();

    $users = User::all();
} else {
    echo "تم العثور على " . $users->count() . " مستخدم في النظام.\n";
}

// إنشاء إشعارات تجريبية
$notificationTypes = [
    'maintenance_due' => 'صيانة مستحقة قريباً',
    'maintenance_urgent' => 'صيانة عاجلة خلال يومين!',
    'maintenance_overdue' => 'صيانة متأخرة',
    'maintenance_critical_overdue' => 'تحذير: صيانة متأخرة بشكل حرج!',
    'contract_expiring' => 'عقد صيانة على وشك الانتهاء',
    'daily_maintenance' => 'صيانة مستحقة اليوم'
];

$priorities = ['normal', 'high', 'critical'];
$count = 0;

foreach ($users as $user) {
    foreach ($notificationTypes as $type => $title) {
        $priority = $type === 'maintenance_critical_overdue' ? 'critical' : ($type === 'maintenance_urgent' || $type === 'maintenance_overdue' ? 'high' : 'normal');

        $notification = new Notification();
        $notification->company_id = $user->company_id ?? 1;
        $notification->user_id = $user->id;
        $notification->type = $type;
        $notification->notifiable_type = 'App\\Models\\MaintenanceSchedule';
        $notification->notifiable_id = rand(1, 100); // رقم عشوائي
        $notification->title = $title;
        $notification->message = "هذا إشعار تجريبي من نوع {$type} للمستخدم {$user->name}";
        $notification->data = json_encode([
            'schedule_id' => rand(1, 100),
            'elevator_id' => rand(1, 50),
            'contract_id' => rand(1, 30),
            'scheduled_date' => Carbon::now()->addDays(rand(-10, 10))->format('Y-m-d'),
            'details' => "تفاصيل المصعد: موديل تجريبي\nالرقم التسلسلي: SN12345\nالعميل: عميل تجريبي\nالموقع: موقع تجريبي\nتاريخ الصيانة: " . Carbon::now()->addDays(rand(-10, 10))->format('Y-m-d'),
            'customer' => 'عميل تجريبي',
            'location' => 'موقع تجريبي',
            'severity' => $priority === 'critical' ? 'حرج' : ($priority === 'high' ? 'عالي' : 'عادي'),
        ]);
        $notification->priority = $priority;
        $notification->status = 'unread';
        $notification->read_at = null;
        $notification->created_at = Carbon::now()->subHours(rand(1, 48));
        $notification->updated_at = Carbon::now();
        $notification->save();

        $count++;
    }
}

echo "تم إنشاء {$count} إشعار تجريبي بنجاح.\n";
