<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Elevator;
use App\Models\MaintenanceSchedule;
use App\Models\MaintenanceContract;
use App\Models\Company;
use App\Models\User;
use App\Models\Customer;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

// التحقق من وجود شركة
$company = Company::first();
if (!$company) {
    echo "لا توجد شركات في النظام. يرجى إنشاء شركة أولاً.\n";
    exit;
}

// التحقق من وجود مستخدمين
$users = User::all();
if ($users->isEmpty()) {
    echo "لا يوجد مستخدمين في النظام. يرجى إنشاء مستخدم أولاً.\n";
    exit;
}

// التحقق من وجود مصاعد
$elevators = Elevator::all();
if ($elevators->isEmpty()) {
    echo "لا توجد مصاعد في النظام. سيتم إنشاء مصاعد تجريبية.\n";

    // إنشاء مصاعد تجريبية
    for ($i = 1; $i <= 5; $i++) {
        $elevator = new Elevator();
        $elevator->company_id = $company->id;
        $elevator->serial_number = 'SN' . str_pad($i, 5, '0', STR_PAD_LEFT);
        $elevator->model = 'موديل تجريبي ' . $i;
        $elevator->manufacturer = 'شركة تجريبية';
        $elevator->installation_date = Carbon::now()->subYears(rand(1, 5))->format('Y-m-d');
        $elevator->location = 'موقع تجريبي ' . $i;
        $elevator->customer_name = 'عميل تجريبي ' . $i;
        $elevator->status = 'active';
        $elevator->save();
    }

    $elevators = Elevator::all();
    echo "تم إنشاء " . $elevators->count() . " مصعد تجريبي.\n";
}

// التحقق من وجود عقود
$contracts = Contract::all();
if ($contracts->isEmpty()) {
    echo "لا توجد عقود في النظام. سيتم إنشاء عقود تجريبية.\n";

    // إنشاء عقود تجريبية
    foreach ($elevators as $index => $elevator) {
        $contract = new Contract();
        $contract->company_id = $company->id;
        $contract->contract_number = 'CNT' . str_pad($index + 1, 5, '0', STR_PAD_LEFT);
        $contract->customer_id = 1; // افتراضي
        $contract->start_date = Carbon::now()->subMonths(rand(1, 11))->format('Y-m-d');
        $contract->end_date = Carbon::now()->addDays(rand(5, 60))->format('Y-m-d'); // بعضها سينتهي قريباً
        $contract->contract_type = 'maintenance';
        $contract->status = 'active';
        $contract->total_amount = rand(5000, 20000);
        $contract->save();

        // ربط المصعد بالعقد
        DB::table('contract_elevator')->insert([
            'contract_id' => $contract->id,
            'elevator_id' => $elevator->id,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now()
        ]);
    }

    $contracts = Contract::all();
    echo "تم إنشاء " . $contracts->count() . " عقد تجريبي.\n";
}

// حذف جداول الصيانة الحالية
DB::table('maintenance_schedules')->truncate();
echo "تم حذف جداول الصيانة الحالية.\n";

// إنشاء جداول صيانة متنوعة
$maintenanceTypes = ['دورية', 'طارئة', 'وقائية'];
$statuses = ['pending', 'completed', 'in_progress', 'cancelled'];
$count = 0;

// 1. صيانة مستحقة في المستقبل القريب (خلال 7 أيام)
for ($i = 1; $i <= 5; $i++) {
    $schedule = new MaintenanceSchedule();
    $schedule->company_id = $company->id;
    $schedule->elevator_id = $elevators->random()->id;
    $schedule->contract_id = $contracts->random()->id;
    $schedule->scheduled_date = Carbon::now()->addDays(rand(1, 7))->format('Y-m-d');
    $schedule->maintenance_type = $maintenanceTypes[array_rand($maintenanceTypes)];
    $schedule->description = 'صيانة مستقبلية قريبة رقم ' . $i;
    $schedule->status = 'pending';
    $schedule->created_by = $users->random()->id;
    $schedule->save();
    $count++;
}

// 2. صيانة مستحقة اليوم
for ($i = 1; $i <= 3; $i++) {
    $schedule = new MaintenanceSchedule();
    $schedule->company_id = $company->id;
    $schedule->elevator_id = $elevators->random()->id;
    $schedule->contract_id = $contracts->random()->id;
    $schedule->scheduled_date = Carbon::now()->format('Y-m-d');
    $schedule->maintenance_type = $maintenanceTypes[array_rand($maintenanceTypes)];
    $schedule->description = 'صيانة مستحقة اليوم رقم ' . $i;
    $schedule->status = 'pending';
    $schedule->created_by = $users->random()->id;
    $schedule->save();
    $count++;
}

// 3. صيانة متأخرة
for ($i = 1; $i <= 4; $i++) {
    $schedule = new MaintenanceSchedule();
    $schedule->company_id = $company->id;
    $schedule->elevator_id = $elevators->random()->id;
    $schedule->contract_id = $contracts->random()->id;
    $schedule->scheduled_date = Carbon::now()->subDays(rand(1, 15))->format('Y-m-d');
    $schedule->maintenance_type = $maintenanceTypes[array_rand($maintenanceTypes)];
    $schedule->description = 'صيانة متأخرة رقم ' . $i;
    $schedule->status = 'pending';
    $schedule->created_by = $users->random()->id;
    $schedule->save();
    $count++;
}

// 4. صيانة متأخرة بشكل حرج (أكثر من 7 أيام)
for ($i = 1; $i <= 2; $i++) {
    $schedule = new MaintenanceSchedule();
    $schedule->company_id = $company->id;
    $schedule->elevator_id = $elevators->random()->id;
    $schedule->contract_id = $contracts->random()->id;
    $schedule->scheduled_date = Carbon::now()->subDays(rand(8, 30))->format('Y-m-d');
    $schedule->maintenance_type = $maintenanceTypes[array_rand($maintenanceTypes)];
    $schedule->description = 'صيانة متأخرة بشكل حرج رقم ' . $i;
    $schedule->status = 'pending';
    $schedule->created_by = $users->random()->id;
    $schedule->save();
    $count++;
}

echo "تم إنشاء {$count} جدول صيانة تجريبي بنجاح.\n";
echo "الآن قم بزيارة الموقع لتشغيل المهام المجدولة وإنشاء الإشعارات تلقائياً.\n";
