CREATE TABLE IF NOT EXISTS `elevator_inventory_request_items` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `elevator_inventory_request_id` bigint(20) UNSIGNED NOT NULL,
  `inventory_item_id` bigint(20) UNSIGNED NOT NULL,
  `warehouse_id` bigint(20) UNSIGNED NOT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `fulfilled_quantity` decimal(10,2) NOT NULL DEFAULT '0.00',
  `status` enum('pending','approved','rejected','fulfilled','partially_fulfilled') NOT NULL DEFAULT 'pending',
  `notes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rejection_reason` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') NOT NULL DEFAULT 'medium',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eir_items_request_id_foreign` (`elevator_inventory_request_id`),
  KEY `elevator_inventory_request_items_inventory_item_id_foreign` (`inventory_item_id`),
  KEY `elevator_inventory_request_items_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `eir_items_request_id_foreign` FOREIGN KEY (`elevator_inventory_request_id`) REFERENCES `elevator_inventory_requests` (`id`) ON DELETE CASCADE,
  CONSTRAINT `elevator_inventory_request_items_inventory_item_id_foreign` FOREIGN KEY (`inventory_item_id`) REFERENCES `inventory_items` (`id`),
  CONSTRAINT `elevator_inventory_request_items_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;