<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;
use App\Models\Company;

// إيجاد المستخدم التجريبي
$user = User::where('email', 'demo@elevators.com')->first();

if (!$user) {
    echo "المستخدم التجريبي غير موجود!\n";
    exit;
}

// إنشاء شركة جديدة
$company = new Company();
$company->name = "شركة المصاعد التجريبية";
$company->email = "info@demo-elevators.com";
$company->phone = "0123456789";
$company->address = "عنوان الشركة التجريبية";
$company->city = "المدينة";
$company->country = "البلد";
$company->tax_number = "123456789";
$company->registration_number = "987654321";
$company->website = "https://demo-elevators.com";
$company->is_active = true;
$company->save();

echo "تم إنشاء الشركة بنجاح:\n";
echo "المعرف: " . $company->id . "\n";
echo "الاسم: " . $company->name . "\n";

// ربط المستخدم بالشركة
$user->company_id = $company->id;
$user->save();

echo "\nتم ربط المستخدم بالشركة بنجاح!\n";
echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";
echo "معرف الشركة: " . $user->company_id . "\n";
