<?php

// Cargar el framework Laravel
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;

// Crear el usuario administrador
$user = User::updateOrCreate(
    ['email' => 'admin@example.com'],
    [
        'name' => 'مدير النظام',
        'password' => Hash::make('password'),
        'email_verified_at' => now(),
        'is_active' => true,
    ]
);

echo "Usuario creado con ID: " . $user->id . "\n";

// Asignar el rol de super_admin
$role = Role::where('slug', 'super_admin')->first();
if ($role) {
    $user->roles()->sync([$role->id]);
    echo "Rol asignado: " . $role->name . "\n";
} else {
    echo "No se encontró el rol super_admin\n";
}

echo "¡Proceso completado!\n";
