<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// التحقق من وجود حساب فروق ميزان المراجعة
$adjustmentAccount = ChartOfAccount::where('name', 'فروق ميزان المراجعة')
    ->orWhere('account_code', 'ADJ-DIFF')
    ->first();

if ($adjustmentAccount) {
    echo "حساب فروق ميزان المراجعة موجود بالفعل برمز: " . $adjustmentAccount->account_code . "\n";
} else {
    // إنشاء حساب جديد
    $adjustmentAccount = new ChartOfAccount();
    $adjustmentAccount->name = 'فروق ميزان المراجعة';
    $adjustmentAccount->account_code = 'ADJ-DIFF';
    $adjustmentAccount->account_type = 'expense'; // نوع الحساب مصروفات
    $adjustmentAccount->parent_id = null; // حساب رئيسي
    $adjustmentAccount->opening_balance = 0;
    $adjustmentAccount->current_balance = 0;
    $adjustmentAccount->balance_type = 'debit'; // رصيد مدين
    $adjustmentAccount->description = 'حساب لتسوية فروق ميزان المراجعة';
    $adjustmentAccount->company_id = 1; // استخدام الشركة رقم 1
    $adjustmentAccount->save();

    echo "تم إنشاء حساب فروق ميزان المراجعة برمز: " . $adjustmentAccount->account_code . "\n";
}

echo "تم الانتهاء من العملية.";
