<?php
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // مسح ذاكرة التخزين المؤقت للصلاحيات
    \Illuminate\Support\Facades\Cache::flush();
    echo "تم مسح ذاكرة التخزين المؤقت بنجاح\n";

    // إعادة تحميل الصلاحيات للمستخدم
    $user = \App\Models\User::where('email', 'fany@fany.com')->first();
    if (!$user) {
        echo "لم يتم العثور على المستخدم fany@fany.com\n";
        exit(1);
    }

    echo "تم العثور على المستخدم: " . $user->name . " (ID: " . $user->id . ")\n";

    // إعادة تحميل الأدوار والصلاحيات
    $user->load('roles.permissions');

    echo "تم إعادة تحميل الأدوار والصلاحيات بنجاح\n";

    // التحقق من صلاحيات الصيانة
    $maintenancePermissions = [
        'view_maintenance_notifications',
        'view-maintenance-schedule',
        'view-maintenance-log'
    ];

    echo "\nالتحقق من صلاحيات الصيانة للمستخدم:\n";
    echo "----------------------------------------\n";

    foreach ($maintenancePermissions as $permSlug) {
        $hasPermission = false;

        foreach ($user->roles as $role) {
            foreach ($role->permissions as $perm) {
                if ($perm->slug === $permSlug) {
                    $hasPermission = true;
                    echo "الصلاحية " . $perm->name . " (" . $permSlug . ") متاحة من خلال دور: " . $role->name . "\n";
                    break 2;
                }
            }
        }

        if (!$hasPermission) {
            echo "الصلاحية " . $permSlug . " غير متاحة للمستخدم\n";
        }
    }

    echo "----------------------------------------\n";
    echo "تم تنفيذ العملية بنجاح\n";
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
