<?php
require 'vendor/autoload.php';

// تحميل متغيرات البيئة
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// إعداد اتصال قاعدة البيانات
$db = new PDO(
    'mysql:host=' . getenv('DB_HOST') . ';dbname=' . getenv('DB_DATABASE'),
    getenv('DB_USERNAME'),
    getenv('DB_PASSWORD')
);

// استعلام لعرض بنية جدول work_orders
$stmt = $db->query('DESCRIBE work_orders');
$columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "بنية جدول work_orders:\n";
foreach ($columns as $column) {
    echo "{$column['Field']} - {$column['Type']} - {$column['Null']} - {$column['Key']} - {$column['Default']}\n";
}

// استعلام لعرض بيانات أمر شغل واحد
$stmt = $db->query('SELECT * FROM work_orders LIMIT 1');
$workOrder = $stmt->fetch(PDO::FETCH_ASSOC);

if ($workOrder) {
    echo "\nبيانات أمر شغل واحد:\n";
    foreach ($workOrder as $key => $value) {
        echo "{$key}: {$value}\n";
    }
}
