<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\WorkOrder;
use Illuminate\Support\Facades\DB;

// Check if the work_orders table exists
$tableExists = DB::getSchemaBuilder()->hasTable('work_orders');
echo "Work orders table exists: " . ($tableExists ? 'Yes' : 'No') . "\n";

if ($tableExists) {
    // Count all work orders
    $totalCount = WorkOrder::count();
    echo "Total work orders: " . $totalCount . "\n";

    // Count open work orders
    $openCount = WorkOrder::where('status', 'open')->count();
    echo "Open work orders: " . $openCount . "\n";

    // Get a list of all work orders with their status
    $workOrders = WorkOrder::select('id', 'status', 'company_id')->get();
    echo "Work orders list:\n";
    foreach ($workOrders as $order) {
        echo "ID: " . $order->id . ", Status: " . $order->status . ", Company ID: " . $order->company_id . "\n";
    }
} else {
    echo "The work_orders table does not exist in the database.\n";
}
