<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\WorkOrder;
use Illuminate\Support\Facades\DB;

// Get the work order with ID 4
$workOrder = WorkOrder::find(4);

if ($workOrder) {
    echo "Work Order Details:\n";
    echo "ID: " . $workOrder->id . "\n";
    echo "Status: " . $workOrder->status . "\n";
    echo "Company ID: " . $workOrder->company_id . "\n";

    // Check if order_number exists
    if (Schema::hasColumn('work_orders', 'order_number')) {
        echo "Order Number: " . ($workOrder->order_number ?? 'NULL') . "\n";
    } else {
        echo "The 'order_number' column does not exist in the work_orders table.\n";

        // Show all columns in the work_orders table
        echo "\nColumns in work_orders table:\n";
        $columns = Schema::getColumnListing('work_orders');
        print_r($columns);
    }

    // Show all attributes of the work order
    echo "\nAll attributes:\n";
    print_r($workOrder->getAttributes());
} else {
    echo "Work order with ID 4 not found.\n";
}
