<?php
require 'vendor/autoload.php';

// تحميل متغيرات البيئة
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
$dotenv->load();

// إعداد اتصال قاعدة البيانات
$db = new PDO(
    'mysql:host=' . getenv('DB_HOST') . ';dbname=' . getenv('DB_DATABASE'),
    getenv('DB_USERNAME'),
    getenv('DB_PASSWORD')
);

// استعلام للتحقق من أمر شغل محدد
$workOrderId = 1; // يمكن تغييره حسب الحاجة
$stmt = $db->prepare('SELECT wo.*, e.serial_number, pp.name as phase_name 
                      FROM work_orders wo 
                      LEFT JOIN elevators e ON wo.elevator_id = e.id 
                      LEFT JOIN project_phases pp ON wo.project_phase_id = pp.id 
                      WHERE wo.id = ?');
$stmt->execute([$workOrderId]);
$workOrder = $stmt->fetch(PDO::FETCH_ASSOC);

if ($workOrder) {
    echo "معلومات أمر الشغل #{$workOrder['id']}:\n";
    echo "رقم المصعد: {$workOrder['serial_number']}\n";
    echo "اسم المرحلة: {$workOrder['phase_name']}\n";
    echo "حالة أمر الشغل: {$workOrder['status']}\n";
} else {
    echo "لم يتم العثور على أمر الشغل رقم {$workOrderId}";
}
