<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Get the first user to check the structure
$user = \App\Models\User::first();

if (!$user) {
    echo "No users found in the database\n";
    exit;
}

echo "User ID: " . $user->id . "\n";
echo "User attributes:\n";
print_r($user->getAttributes());

// Try to find manager3 by ID
echo "\nTrying to find manager3 by ID or name...\n";
$users = \App\Models\User::all();
foreach ($users as $u) {
    echo "ID: " . $u->id . ", Name: " . $u->name . "\n";
    if (strtolower($u->name) == 'manager3' || $u->id == 'manager3') {
        echo "Found manager3!\n";
        $manager3 = $u;
    }
}

// If we found manager3
if (isset($manager3)) {
    echo "\nManager3 details:\n";
    print_r($manager3->getAttributes());

    // Get direct permissions
    $directPermissions = $manager3->permissions()->pluck('name')->toArray();

    // Get permissions from roles
    $rolePermissions = [];
    foreach ($manager3->roles as $role) {
        $rolePerms = $role->permissions()->pluck('name')->toArray();
        $rolePermissions = array_merge($rolePermissions, $rolePerms);
    }

    // Combine all permissions
    $permissions = array_unique(array_merge($directPermissions, $rolePermissions));
    echo "\nTotal permissions: " . count($permissions) . "\n";

    $customerInteractionPermissions = [
        'view_customer_interaction',
        'create_customer_interaction',
        'edit_customer_interaction',
        'delete_customer_interaction',
        'manage_customer_interactions'
    ];

    $customerRewardPermissions = [
        'view_customer_reward',
        'create_customer_reward',
        'edit_customer_reward',
        'delete_customer_reward'
    ];

    echo "\nCustomer Interaction Permissions:\n";
    foreach ($customerInteractionPermissions as $perm) {
        echo $perm . ": " . (in_array($perm, $permissions) ? "YES" : "NO") . "\n";
    }

    echo "\nCustomer Reward Permissions:\n";
    foreach ($customerRewardPermissions as $perm) {
        echo $perm . ": " . (in_array($perm, $permissions) ? "YES" : "NO") . "\n";
    }

    echo "\nShould see menu: " . (
        in_array('view_customer_interaction', $permissions) ||
        in_array('create_customer_interaction', $permissions) ||
        in_array('manage_customer_interactions', $permissions) ||
        in_array('view_customer_reward', $permissions) ||
        in_array('create_customer_reward', $permissions) ||
        in_array('edit_customer_reward', $permissions) ||
        in_array('delete_customer_reward', $permissions) ? "YES" : "NO"
    ) . "\n";
}
