<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// البحث عن المستخدم manager3
$user = \App\Models\User::where('email', 'manager3@manager3.com')->first();

if (!$user) {
    echo "لم يتم العثور على المستخدم manager3!\n";
    exit;
}

echo "معلومات المستخدم: " . $user->name . " (ID: " . $user->id . ", البريد الإلكتروني: " . $user->email . ")\n\n";

// الحصول على أدوار المستخدم
echo "أدوار المستخدم:\n";
$roles = $user->roles;
foreach ($roles as $role) {
    echo "- " . $role->name . " (ID: " . $role->id . ")\n";
}

// الحصول على صلاحيات المستخدم المباشرة
echo "\nصلاحيات المستخدم المباشرة:\n";
$directPermissions = $user->permissions;
if ($directPermissions->count() > 0) {
    foreach ($directPermissions as $perm) {
        echo "- " . $perm->name . " (slug: " . $perm->slug . ", group: " . $perm->group . ")\n";
    }
} else {
    echo "لا توجد صلاحيات مباشرة معينة.\n";
}

// التحقق من صلاحيات تفاعلات العملاء
$interactionPermissions = [
    'manage_customer_interactions',
    'view_customer_interaction',
    'create_customer_interaction',
    'edit_customer_interaction',
    'delete_customer_interaction'
];

echo "\nصلاحيات تفاعلات العملاء:\n";
foreach ($interactionPermissions as $permission) {
    echo "- " . $permission . ": " . ($user->hasPermissionTo($permission) ? "نعم" : "لا") . "\n";
}

// التحقق من صلاحيات مكافآت العملاء
$rewardPermissions = [
    'manage_customer_rewards',
    'view_customer_reward',
    'create_customer_reward',
    'edit_customer_reward',
    'delete_customer_reward'
];

echo "\nصلاحيات مكافآت العملاء:\n";
foreach ($rewardPermissions as $permission) {
    echo "- " . $permission . ": " . ($user->hasPermissionTo($permission) ? "نعم" : "لا") . "\n";
}

// التحقق من صلاحيات المخزون المحددة
$inventoryPermissions = [
    'view_warehouses',
    'view_suppliers',
    'view_inventory_items',
    'view_inventory_stock',
    'view_purchase_orders',
    'view_inventory_transactions',
    'view_inventory_reports'
];

echo "\nصلاحيات المخزون:\n";
foreach ($inventoryPermissions as $permission) {
    echo "- " . $permission . ": " . ($user->hasPermissionTo($permission) ? "نعم" : "لا") . "\n";
}
