<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;
use Illuminate\Support\Facades\Auth;

// Get all users with their company IDs
$users = User::select('id', 'name', 'email', 'company_id')->get();

echo "Users and their company IDs:\n";
foreach ($users as $user) {
    echo "User ID: " . $user->id . ", Name: " . $user->name . ", Email: " . $user->email . ", Company ID: " . $user->company_id . "\n";
}

// Check if there's a currently authenticated user
if (Auth::check()) {
    $currentUser = Auth::user();
    echo "\nCurrently authenticated user:\n";
    echo "User ID: " . $currentUser->id . ", Name: " . $currentUser->name . ", Company ID: " . $currentUser->company_id . "\n";
} else {
    echo "\nNo user is currently authenticated.\n";
}
