<?php
require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Check for user3
$user = \App\Models\User::where('name', 'user3')->first();

if ($user) {
    echo "User: {$user->name} (ID: {$user->id})\n";

    // Check for view_inventory permission
    if ($user->hasPermissionTo('view_inventory')) {
        echo "Has view_inventory permission: YES\n";
    } else {
        echo "Has view_inventory permission: NO\n";
    }

    // Check roles
    echo "\nRoles:\n";
    foreach ($user->roles as $role) {
        echo "- {$role->name}\n";
    }

    // Check if any of the roles have the view_inventory permission
    echo "\nRoles with view_inventory permission:\n";
    $hasRoleWithPermission = false;

    // Get the permission
    $permission = \Spatie\Permission\Models\Permission::where('name', 'view_inventory')->first();

    if ($permission) {
        // Get roles that have this permission
        $rolesWithPermission = $permission->roles;

        foreach ($user->roles as $userRole) {
            foreach ($rolesWithPermission as $permRole) {
                if ($userRole->id === $permRole->id) {
                    echo "- {$userRole->name}\n";
                    $hasRoleWithPermission = true;
                    break;
                }
            }
        }
    } else {
        echo "Permission 'view_inventory' not found in the system\n";
    }

    if (!$hasRoleWithPermission && $permission) {
        echo "None of the roles have view_inventory permission\n";
    }
} else {
    echo "User 'user3' not found\n";
}
