<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\User;

// إيجاد المستخدم التجريبي
$user = User::where('email', 'demo@elevators.com')->first();

if (!$user) {
    echo "المستخدم التجريبي غير موجود!\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";
echo "الحالة: " . ($user->is_active ? "نشط" : "غير نشط") . "\n";

echo "\nالأدوار:\n";
foreach ($user->roles as $role) {
    echo "- " . $role->name . " (" . $role->display_name . ")\n";
}

echo "\nعدد الصلاحيات: " . $user->getAllPermissions()->count() . "\n";
echo "الصلاحيات الأولى 10:\n";
$i = 1;
foreach ($user->getAllPermissions()->take(10) as $permission) {
    echo $i . ". " . $permission->name . "\n";
    $i++;
}
