<?php
require 'vendor/autoload.php';
require 'bootstrap/app.php';

// تهيئة التطبيق
$app = $GLOBALS['app'];
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// استخراج بيانات ميزان المراجعة
$debitAccounts = DB::table('chart_of_accounts')
    ->whereIn('account_type', ['asset', 'expense'])
    ->get(['id', 'name', 'account_code', 'current_balance']);

$creditAccounts = DB::table('chart_of_accounts')
    ->whereIn('account_type', ['liability', 'equity', 'revenue'])
    ->get(['id', 'name', 'account_code', 'current_balance']);

// حساب الإجماليات
$totalDebit = $debitAccounts->sum('current_balance');
$totalCredit = $creditAccounts->sum('current_balance');

// عرض النتائج
echo "=== تقرير ميزان المراجعة ===\n\n";

echo "== حسابات المدين ==\n";
foreach ($debitAccounts as $account) {
    echo "{$account->account_code} - {$account->name}: {$account->current_balance}\n";
}
echo "إجمالي المدين: {$totalDebit}\n\n";

echo "== حسابات الدائن ==\n";
foreach ($creditAccounts as $account) {
    echo "{$account->account_code} - {$account->name}: {$account->current_balance}\n";
}
echo "إجمالي الدائن: {$totalCredit}\n\n";

echo "== ملخص ==\n";
echo "إجمالي المدين: {$totalDebit}\n";
echo "إجمالي الدائن: {$totalCredit}\n";
echo "الفرق: " . ($totalDebit - $totalCredit) . "\n";

// التحقق من القيود المحاسبية
echo "\n=== فحص القيود المحاسبية ===\n\n";
$entries = DB::table('journal_entries')
    ->select('id', 'entry_number', 'entry_date')
    ->get();

$unbalancedEntries = [];
foreach ($entries as $entry) {
    // حساب إجمالي المدين والدائن لكل قيد
    $totals = DB::table('journal_entry_items')
        ->where('journal_entry_id', $entry->id)
        ->selectRaw('SUM(debit) as total_debit, SUM(credit) as total_credit')
        ->first();

    if ($totals) {
        $difference = $totals->total_debit - $totals->total_credit;
        if (abs($difference) > 0.01) {
            $unbalancedEntries[] = [
                'id' => $entry->id,
                'entry_number' => $entry->entry_number,
                'entry_date' => $entry->entry_date,
                'total_debit' => $totals->total_debit,
                'total_credit' => $totals->total_credit,
                'difference' => $difference
            ];
        }
    }
}

if (count($unbalancedEntries) > 0) {
    echo "القيود غير المتوازنة:\n";
    foreach ($unbalancedEntries as $entry) {
        echo "القيد رقم: {$entry['entry_number']} (ID: {$entry['id']}), التاريخ: {$entry['entry_date']}\n";
        echo "المدين: {$entry['total_debit']}, الدائن: {$entry['total_credit']}, الفرق: {$entry['difference']}\n\n";

        // عرض تفاصيل بنود القيد
        echo "تفاصيل بنود القيد:\n";
        $items = DB::table('journal_entry_items')
            ->join('chart_of_accounts', 'chart_of_accounts.id', '=', 'journal_entry_items.account_id')
            ->where('journal_entry_id', $entry['id'])
            ->select('journal_entry_items.id', 'chart_of_accounts.account_code', 'chart_of_accounts.name', 'journal_entry_items.debit', 'journal_entry_items.credit', 'journal_entry_items.description')
            ->get();

        foreach ($items as $item) {
            echo "- {$item->account_code} - {$item->name}: المدين: {$item->debit}, الدائن: {$item->credit}\n";
        }
        echo "\n";
    }
} else {
    echo "جميع القيود متوازنة.\n";
}

// التحقق من حساب فروق ميزان المراجعة
echo "\n=== حساب فروق ميزان المراجعة ===\n\n";
$adjustmentAccount = DB::table('chart_of_accounts')
    ->where('account_code', 'ADJ-DIFF')
    ->first();

if ($adjustmentAccount) {
    echo "حساب فروق ميزان المراجعة: {$adjustmentAccount->name} (الرصيد: {$adjustmentAccount->current_balance})\n";

    // عرض بنود القيود المرتبطة بحساب فروق ميزان المراجعة
    $adjustmentItems = DB::table('journal_entry_items')
        ->join('journal_entries', 'journal_entries.id', '=', 'journal_entry_items.journal_entry_id')
        ->where('journal_entry_items.account_id', $adjustmentAccount->id)
        ->select(
            'journal_entries.entry_number',
            'journal_entries.entry_date',
            'journal_entry_items.debit',
            'journal_entry_items.credit',
            'journal_entry_items.description'
        )
        ->get();

    if (count($adjustmentItems) > 0) {
        echo "\nبنود القيود المرتبطة بحساب فروق ميزان المراجعة:\n";
        foreach ($adjustmentItems as $item) {
            echo "القيد رقم: {$item->entry_number}, التاريخ: {$item->entry_date}\n";
            echo "المدين: {$item->debit}, الدائن: {$item->credit}, الوصف: {$item->description}\n\n";
        }
    } else {
        echo "\nلا توجد بنود مرتبطة بحساب فروق ميزان المراجعة.\n";
    }
} else {
    echo "لم يتم العثور على حساب فروق ميزان المراجعة.\n";
}
