<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

// التحقق من وجود جدول cash_registers
echo "قاعدة البيانات: " . env('DB_DATABASE') . "\n";
echo "اسم المستخدم: " . env('DB_USERNAME') . "\n";
echo "المضيف: " . env('DB_HOST') . "\n";
echo "المنفذ: " . env('DB_PORT') . "\n";

// عرض قائمة الجداول
$tables = DB::select('SHOW TABLES');
echo "الجداول الموجودة:\n";
foreach ($tables as $table) {
    $tableName = reset($table);
    echo "- " . $tableName . "\n";
}

// التحقق من وجود جدول cash_registers
if (Schema::hasTable('cash_registers')) {
    echo "\nجدول cash_registers موجود.\n";

    // عرض هيكل الجدول
    $columns = DB::select("SHOW COLUMNS FROM cash_registers");
    echo "أعمدة الجدول:\n";
    foreach ($columns as $column) {
        echo "- " . $column->Field . ": " . $column->Type . " (Null: " . $column->Null . ")\n";
    }
} else {
    echo "\nجدول cash_registers غير موجود.\n";
}
