<?php
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/bootstrap/app.php';

$app = new Illuminate\Foundation\Application(
    realpath(__DIR__)
);

$app->singleton(
    Illuminate\Contracts\Http\Kernel::class,
    App\Http\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Console\Kernel::class,
    App\Console\Kernel::class
);

$app->singleton(
    Illuminate\Contracts\Debug\ExceptionHandler::class,
    App\Exceptions\Handler::class
);

$app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Obtener todos los estados de cuenta
$statements = DB::table('customer_statements')->get();

echo "Total de estados de cuenta: " . count($statements) . "\n\n";

foreach ($statements as $stmt) {
    echo "ID: " . $stmt->id .
        ", Cliente: " . $stmt->customer_id .
        ", Fecha: " . $stmt->transaction_date .
        ", Referencia: " . $stmt->reference_type . " #" . $stmt->reference_id .
        ", Número: " . $stmt->reference_number .
        ", Descripción: " . $stmt->description .
        ", Débito: " . $stmt->debit .
        ", Crédito: " . $stmt->credit .
        ", Balance: " . $stmt->balance . "\n";
}

// Obtener información del cliente 9
$customer = \App\Models\Customer::find(9);
if ($customer) {
    echo "\nInformación del cliente ID 9:\n";
    echo "Nombre: " . $customer->name . "\n";
    echo "Nombre en inglés: " . $customer->name_en . "\n";
    echo "Código: " . $customer->code . "\n";
}

// Verificar si hay algún estado de cuenta para el cliente 9
$customerStatements = DB::table('customer_statements')
    ->where('customer_id', 9)
    ->orderBy('transaction_date', 'asc')
    ->get();

echo "\nEstados de cuenta para el cliente ID 9: " . count($customerStatements) . "\n";

foreach ($customerStatements as $stmt) {
    echo "ID: " . $stmt->id .
        ", Fecha: " . $stmt->transaction_date .
        ", Referencia: " . $stmt->reference_type . " #" . $stmt->reference_id .
        ", Número: " . $stmt->reference_number .
        ", Descripción: " . $stmt->description .
        ", Débito: " . $stmt->debit .
        ", Crédito: " . $stmt->credit .
        ", Balance: " . $stmt->balance . "\n";
}

// Verificar si hay algún estado de cuenta para el asiento contable 33
$journalEntryStatements = DB::table('customer_statements')
    ->where('reference_type', 'App\Models\JournalEntry')
    ->where('reference_id', 33)
    ->get();

echo "\nEstados de cuenta para el asiento contable ID 33: " . count($journalEntryStatements) . "\n";

foreach ($journalEntryStatements as $stmt) {
    echo "ID: " . $stmt->id .
        ", Cliente: " . $stmt->customer_id .
        ", Fecha: " . $stmt->transaction_date .
        ", Número: " . $stmt->reference_number .
        ", Descripción: " . $stmt->description .
        ", Débito: " . $stmt->debit .
        ", Crédito: " . $stmt->credit .
        ", Balance: " . $stmt->balance . "\n";
}
