<?php

// تحميل التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// استخدام النماذج
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

// التحقق من وجود جدول roles
if (Schema::hasTable('roles')) {
    echo "جدول roles موجود في قاعدة البيانات.\n";

    // التحقق من وجود الأعمدة المطلوبة
    $columns = Schema::getColumnListing('roles');
    echo "الأعمدة الموجودة في جدول roles:\n";
    foreach ($columns as $column) {
        echo "- " . $column . "\n";
    }

    // التحقق من وجود عمود level
    if (in_array('level', $columns)) {
        echo "عمود level موجود في جدول roles.\n";
    } else {
        echo "عمود level غير موجود في جدول roles!\n";
    }

    // التحقق من وجود عمود path
    if (in_array('path', $columns)) {
        echo "عمود path موجود في جدول roles.\n";
    } else {
        echo "عمود path غير موجود في جدول roles!\n";
    }

    // عرض عدد السجلات في جدول roles
    $rolesCount = DB::table('roles')->count();
    echo "عدد السجلات في جدول roles: " . $rolesCount . "\n";

    // عرض أول 5 سجلات في جدول roles
    $roles = DB::table('roles')->limit(5)->get();
    echo "أول 5 سجلات في جدول roles:\n";
    foreach ($roles as $role) {
        echo "ID: " . $role->id . ", الاسم: " . $role->name . ", المعرف: " . $role->slug . "\n";
    }
} else {
    echo "جدول roles غير موجود في قاعدة البيانات!\n";
}
