<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

$email = 'manager3@manager3.com';
$user = \App\Models\User::where('email', $email)->first();

if (!$user) {
    echo "User not found with email: $email\n";
    exit;
}

echo "User found: " . $user->name . "\n";
echo "Roles: " . implode(', ', $user->roles->pluck('name')->toArray()) . "\n";

// Check installation project permissions
$projectPermissions = [
    'view_installation_projects',
    'create_installation_project',
    'edit_installation_project',
    'delete_installation_project',
    'manage_installation_projects'
];

echo "\nProject Permissions:\n";
foreach ($projectPermissions as $permission) {
    echo "$permission: " . ($user->hasPermissionTo($permission) ? 'Yes' : 'No') . "\n";
}

// Check if the user has any permission that would show the sidebar menu
$hasAnyProjectPermission = $user->hasAnyPermission($projectPermissions);
echo "\nHas any project permission: " . ($hasAnyProjectPermission ? 'Yes' : 'No') . "\n";

// Get all permissions for this user
echo "\nAll permissions:\n";
$allPermissions = $user->getAllPermissions();
foreach ($allPermissions as $permission) {
    echo "- " . $permission->name . "\n";
}
