<?php

// تحميل ملفات التطبيق
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// الحصول على المستخدم "manager3" (معرف المستخدم 6)
$user = App\Models\User::find(6);

if (!$user) {
    echo "المستخدم غير موجود\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";
echo "الشركة: " . ($user->company ? $user->company->name : 'غير محدد') . "\n\n";

echo "الأدوار:\n";
foreach ($user->roles as $role) {
    echo "- " . $role->name . " (" . $role->display_name . ")\n";
}
echo "\n";

// التحقق من صلاحيات وحدات الأصناف
$permissions = [
    'view_inventory_item_units',
    'create_inventory_item_units',
    'edit_inventory_item_units',
    'delete_inventory_item_units',
];

echo "صلاحيات وحدات الأصناف:\n";
foreach ($permissions as $permission) {
    echo "- " . $permission . ": " . ($user->hasPermission($permission) ? 'نعم' : 'لا') . "\n";
}
echo "\n";

// عرض جميع صلاحيات المستخدم
echo "جميع الصلاحيات:\n";
$allPermissions = $user->getAllPermissions();
foreach ($allPermissions as $permission) {
    echo "- " . $permission->name . "\n";
}
