<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Get all permissions
$allPermissions = \App\Models\Permission::all();

echo "Total permissions in database: " . $allPermissions->count() . "\n\n";

// Check for customer interaction and reward permissions
$interactionPermissions = \App\Models\Permission::where('slug', 'like', '%customer_interaction%')
    ->orWhere('name', 'like', '%customer_interaction%')
    ->orWhere('group', 'like', '%customer_interaction%')
    ->get();

$rewardPermissions = \App\Models\Permission::where('slug', 'like', '%customer_reward%')
    ->orWhere('name', 'like', '%customer_reward%')
    ->orWhere('group', 'like', '%customer_reward%')
    ->get();

echo "Customer Interaction Permissions:\n";
foreach ($interactionPermissions as $perm) {
    echo "ID: " . $perm->id . ", Name: " . $perm->name . ", Slug: " . $perm->slug . ", Group: " . $perm->group . "\n";
}

echo "\nCustomer Reward Permissions:\n";
foreach ($rewardPermissions as $perm) {
    echo "ID: " . $perm->id . ", Name: " . $perm->name . ", Slug: " . $perm->slug . ", Group: " . $perm->group . "\n";
}

// Check for permissions with similar names
echo "\nSearching for similar permissions...\n";
$searchTerms = [
    'customer',
    'interaction',
    'reward',
    'view',
    'create',
    'edit',
    'delete',
    'manage'
];

foreach ($searchTerms as $term) {
    $similarPerms = \App\Models\Permission::where('slug', 'like', '%' . $term . '%')
        ->orWhere('name', 'like', '%' . $term . '%')
        ->orWhere('group', 'like', '%' . $term . '%')
        ->limit(5) // Limit to avoid too much output
        ->get();

    echo "\nPermissions containing '" . $term . "': " . $similarPerms->count() . "\n";
    foreach ($similarPerms as $perm) {
        echo "ID: " . $perm->id . ", Name: " . $perm->name . ", Slug: " . $perm->slug . ", Group: " . $perm->group . "\n";
    }
}
