<?php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Verificar los permisos de proyectos
$projectPermissions = [
    'view_installation_projects',
    'create_installation_project',
    'edit_installation_project',
    'delete_installation_project',
    'manage_installation_projects'
];

echo "Permisos de proyectos en la base de datos:\n";
foreach ($projectPermissions as $permName) {
    $perm = \App\Models\Permission::where('name', $permName)->first();
    if ($perm) {
        echo "Nombre: {$perm->name}, Slug: {$perm->slug}, ID: {$perm->id}\n";
    } else {
        echo "No se encontró el permiso: {$permName}\n";
    }
}

// Verificar los roles del usuario
$email = 'manager3@manager3.com';
$user = \App\Models\User::where('email', $email)->first();

if (!$user) {
    echo "\nUsuario no encontrado con email: {$email}\n";
    exit;
}

echo "\nRoles del usuario {$user->name}:\n";
foreach ($user->roles as $role) {
    echo "Rol: {$role->name}, ID: {$role->id}\n";

    // Verificar permisos de este rol
    echo "  Permisos de proyectos en este rol:\n";
    foreach ($projectPermissions as $permName) {
        $perm = \App\Models\Permission::where('name', $permName)->first();
        if ($perm) {
            $hasPermission = $role->permissions->contains('id', $perm->id);
            echo "  - {$permName}: " . ($hasPermission ? 'Sí' : 'No') . "\n";
        }
    }
}

// Verificar si el usuario tiene los permisos directamente
echo "\nVerificación directa de permisos:\n";
foreach ($projectPermissions as $permName) {
    $perm = \App\Models\Permission::where('name', $permName)->first();
    if ($perm) {
        $directPerm = $user->directPermissions()->where('permission_id', $perm->id)->first();
        echo "{$permName}: " . ($directPerm ? ($directPerm->granted ? 'Otorgado' : 'Denegado') : 'No asignado directamente') . "\n";
    }
}

// Verificar el método hasPermission
echo "\nVerificación con hasPermission:\n";
foreach ($projectPermissions as $permName) {
    echo "{$permName}: " . ($user->hasPermission($permName) ? 'Sí' : 'No') . "\n";
}

// Verificar el método hasPermissionTo
echo "\nVerificación con hasPermissionTo:\n";
foreach ($projectPermissions as $permName) {
    echo "{$permName}: " . ($user->hasPermissionTo($permName) ? 'Sí' : 'No') . "\n";
}
