<?php

// تحميل الإطار
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// البحث عن المستخدم
$userId = 3; // ID للمستخدم manager3
$user = App\Models\User::find($userId);
if (!$user) {
    echo "لم يتم العثور على المستخدم بالـ ID: $userId\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";
echo "مدير النظام: " . ($user->is_admin ? 'نعم' : 'لا') . "\n\n";

// عرض الأدوار
echo "الأدوار:\n";
foreach ($user->roles as $role) {
    echo "- " . $role->name . " (" . $role->slug . ")\n";

    // عرض صلاحيات الدور
    echo "  صلاحيات الدور:\n";
    foreach ($role->permissions as $permission) {
        echo "  - " . $permission->name . " (" . $permission->slug . ")\n";
    }
}
echo "\n";

// عرض الصلاحيات المباشرة
echo "الصلاحيات المباشرة:\n";
$directPermissions = $user->directPermissions;
if ($directPermissions->count() > 0) {
    foreach ($directPermissions as $userPerm) {
        $permission = $userPerm->permission;
        if ($permission) {
            $status = $userPerm->granted ? 'ممنوحة' : 'محظورة';
            $expires = $userPerm->expires_at ? 'تنتهي في ' . $userPerm->expires_at : 'لا تنتهي';
            echo "- " . $permission->name . " (" . $permission->slug . ") - $status - $expires\n";
        }
    }
} else {
    echo "لا توجد صلاحيات مباشرة\n";
}
echo "\n";

// التحقق من صلاحيات محددة
$permissionsToCheck = [
    'view_inventory_units',
    'create_inventory_units',
    'edit_inventory_units',
    'delete_inventory_units',
    'view_inventory_item_units',
    'create_inventory_item_units',
    'edit_inventory_item_units',
    'delete_inventory_item_units',
    'view_warehouses',
    'view_inventory_items',
    'view_inventory_stock',
    'view_inventory_categories'
];

echo "التحقق من الصلاحيات:\n";
foreach ($permissionsToCheck as $permSlug) {
    $hasPerm = $user->hasPermission($permSlug);
    echo "- $permSlug: " . ($hasPerm ? 'نعم' : 'لا') . "\n";

    // عرض تفاصيل إضافية
    $perm = App\Models\Permission::where('slug', $permSlug)->first();
    if ($perm) {
        echo "  (الصلاحية موجودة في النظام: " . $perm->name . ")\n";

        // التحقق من وجود الصلاحية في الأدوار
        $foundInRoles = false;
        foreach ($user->roles as $role) {
            if ($role->permissions->where('slug', $permSlug)->count() > 0) {
                echo "  (موجودة في دور: " . $role->name . ")\n";
                $foundInRoles = true;
            }
        }

        if (!$foundInRoles) {
            echo "  (غير موجودة في أي دور)\n";
        }

        // التحقق من وجود الصلاحية المباشرة
        $directPerm = $user->directPermissions()
            ->whereHas('permission', function ($query) use ($permSlug) {
                $query->where('slug', $permSlug);
            })
            ->first();

        if ($directPerm) {
            $status = $directPerm->granted ? 'ممنوحة' : 'محظورة';
            $expires = $directPerm->expires_at ? 'تنتهي في ' . $directPerm->expires_at : 'لا تنتهي';
            echo "  (صلاحية مباشرة: $status - $expires)\n";
        } else {
            echo "  (لا توجد صلاحية مباشرة)\n";
        }
    } else {
        echo "  (الصلاحية غير موجودة في النظام)\n";
    }
}

// التحقق من جدول user_permission
echo "\nمحتوى جدول user_permission للمستخدم:\n";
$userPermissions = DB::table('user_permission')
    ->where('user_id', $user->id)
    ->get();

if ($userPermissions->count() > 0) {
    foreach ($userPermissions as $up) {
        $permName = DB::table('permissions')->where('id', $up->permission_id)->value('name');
        $permSlug = DB::table('permissions')->where('id', $up->permission_id)->value('slug');
        $status = $up->granted ? 'ممنوحة' : 'محظورة';
        $expires = $up->expires_at ? 'تنتهي في ' . $up->expires_at : 'لا تنتهي';
        echo "- ID: " . $up->id . " | الصلاحية: " . $permName . " (" . $permSlug . ") | $status | $expires\n";
    }
} else {
    echo "لا توجد سجلات في جدول user_permission لهذا المستخدم\n";
}

// التحقق من مسار الإشعارات
echo "\nالتحقق من مسار الإشعارات:\n";
$routeName = 'notifications.index';
$routes = app('router')->getRoutes();
$route = $routes->getByName($routeName);

if ($route) {
    echo "المسار: " . $routeName . "\n";
    echo "الـ URI: " . $route->uri() . "\n";
    echo "الـ Middleware: " . implode(', ', $route->middleware()) . "\n";

    // التحقق من الصلاحية المطلوبة
    $permissionMiddleware = null;
    foreach ($route->middleware() as $middleware) {
        if (strpos($middleware, 'permission:') === 0) {
            $permissionMiddleware = $middleware;
            break;
        }
    }

    if ($permissionMiddleware) {
        $requiredPermission = str_replace('permission:', '', $permissionMiddleware);
        echo "الصلاحية المطلوبة: " . $requiredPermission . "\n";
        echo "هل المستخدم لديه الصلاحية: " . ($user->hasPermission($requiredPermission) ? 'نعم' : 'لا') . "\n";
    } else {
        echo "لا يوجد middleware للصلاحيات على هذا المسار\n";
    }
} else {
    echo "المسار غير موجود\n";
}

echo "\nتم الانتهاء من التحقق\n";
