<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// البحث عن المستخدم manager3 بالمعرف
$user = \App\Models\User::find(6);

if (!$user) {
    echo "المستخدم manager3 غير موجود في قاعدة البيانات.\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "المعرف: " . $user->id . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";

// البحث عن صلاحيات المخزون المتاحة في النظام
echo "\nصلاحيات المخزون المتاحة في النظام:\n";
$inventoryPermissions = \App\Models\Permission::where('slug', 'like', '%inventory%')
    ->orWhere('name', 'like', '%inventory%')
    ->orWhere('group', 'like', '%inventory%')
    ->get();

foreach ($inventoryPermissions as $perm) {
    echo "ID: " . $perm->id . ", الاسم: " . $perm->name . ", المعرف: " . $perm->slug . ", المجموعة: " . $perm->group . "\n";
    echo "هل المستخدم يملك هذه الصلاحية: " . ($user->hasPermission($perm->slug) ? 'نعم' : 'لا') . "\n";
    echo "-------------------\n";
}

// التحقق من الأدوار
echo "\nأدوار المستخدم:\n";
foreach ($user->roles as $role) {
    echo "- " . $role->name . " (" . $role->id . ")\n";
}

// إضافة صلاحيات وحدات الأصناف للمستخدم
echo "\nإضافة صلاحيات وحدات الأصناف للمستخدم:\n";

$inventoryItemUnitsPermissions = \App\Models\Permission::where('slug', 'like', '%inventory_item_unit%')
    ->orWhere('name', 'like', '%وحدات الأصناف%')
    ->get();

if ($inventoryItemUnitsPermissions->isEmpty()) {
    echo "لا توجد صلاحيات وحدات أصناف في النظام. يجب إنشاؤها أولاً.\n";
} else {
    foreach ($inventoryItemUnitsPermissions as $permission) {
        if (!$user->hasPermission($permission->slug)) {
            $user->permissions()->attach($permission->id);
            echo "تمت إضافة صلاحية: " . $permission->name . " (" . $permission->slug . ")\n";
        } else {
            echo "الصلاحية موجودة بالفعل: " . $permission->name . " (" . $permission->slug . ")\n";
        }
    }
}

echo "\nتم الانتهاء من التحقق وإضافة الصلاحيات اللازمة للمستخدم manager3.\n";
