<?php
require_once __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

$user = \App\Models\User::where('username', 'manager3')->first();

if (!$user) {
    echo "User MANAGER3 not found\n";
    exit;
}

echo "User ID: " . $user->id . "\n";
echo "Username: " . $user->username . "\n";
echo "Roles: " . implode(', ', $user->roles->pluck('name')->toArray()) . "\n";

$permissions = $user->getAllPermissions()->pluck('slug')->toArray();
echo "Total permissions: " . count($permissions) . "\n";

$customerInteractionPermissions = [
    'view_customer_interaction',
    'create_customer_interaction',
    'edit_customer_interaction',
    'delete_customer_interaction',
    'manage_customer_interactions'
];

$customerRewardPermissions = [
    'view_customer_reward',
    'create_customer_reward',
    'edit_customer_reward',
    'delete_customer_reward'
];

echo "\nCustomer Interaction Permissions:\n";
foreach ($customerInteractionPermissions as $perm) {
    echo $perm . ": " . (in_array($perm, $permissions) ? "YES" : "NO") . "\n";
}

echo "\nCustomer Reward Permissions:\n";
foreach ($customerRewardPermissions as $perm) {
    echo $perm . ": " . (in_array($perm, $permissions) ? "YES" : "NO") . "\n";
}

echo "\nShould see menu: " . (
    in_array('view_customer_interaction', $permissions) ||
    in_array('create_customer_interaction', $permissions) ||
    in_array('manage_customer_interactions', $permissions) ||
    in_array('view_customer_reward', $permissions) ||
    in_array('create_customer_reward', $permissions) ||
    in_array('edit_customer_reward', $permissions) ||
    in_array('delete_customer_reward', $permissions) ? "YES" : "NO"
) . "\n";
