<?php
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // البحث عن صلاحيات الصيانة
    echo "البحث عن صلاحيات الصيانة في النظام:\n";
    echo "----------------------------------------\n";

    $maintenancePermissions = \App\Models\Permission::where('slug', 'like', '%maintenance%')
        ->orWhere('group', 'like', '%maintenance%')
        ->get();

    echo "تم العثور على " . $maintenancePermissions->count() . " صلاحية متعلقة بالصيانة:\n\n";

    foreach ($maintenancePermissions as $perm) {
        echo "الاسم: " . $perm->name . "\n";
        echo "المعرف: " . $perm->slug . "\n";
        echo "المجموعة: " . $perm->group . "\n";
        echo "النوع: " . $perm->type . "\n";
        echo "----------------------------------------\n";
    }

    // البحث عن دور الفني
    $techRole = \App\Models\Role::where('name', 'فني')->first();
    if (!$techRole) {
        echo "لم يتم العثور على دور الفني\n";
        exit(1);
    }

    echo "\nصلاحيات دور الفني الحالية:\n";
    echo "----------------------------------------\n";

    $techPermissions = $techRole->permissions;

    if ($techPermissions->count() > 0) {
        foreach ($techPermissions as $perm) {
            echo "الاسم: " . $perm->name . "\n";
            echo "المعرف: " . $perm->slug . "\n";
            echo "المجموعة: " . $perm->group . "\n";
            echo "النوع: " . $perm->type . "\n";
            echo "----------------------------------------\n";
        }
    } else {
        echo "لا توجد صلاحيات مرتبطة بدور الفني\n";
    }
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
