<?php
require_once __DIR__ . '/vendor/autoload.php';

// Initialize Laravel application
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// Get the log file path
$logPath = storage_path('logs/laravel.log');

if (!file_exists($logPath)) {
    echo "Log file not found at: $logPath\n";
    exit(1);
}

// Read the last 100 lines of the log file
$lines = [];
$fp = fopen($logPath, 'r');
if ($fp) {
    // Get file size
    fseek($fp, 0, SEEK_END);
    $size = ftell($fp);

    // Read the last 50KB of the file
    $maxSize = 50 * 1024; // 50KB
    $startPos = max(0, $size - $maxSize);
    fseek($fp, $startPos, SEEK_SET);

    $content = fread($fp, $maxSize);
    fclose($fp);

    // Split into lines
    $lines = explode("\n", $content);
}

// Filter for bank-related errors
$bankErrors = [];
foreach ($lines as $line) {
    if (
        strpos($line, 'Error creating bank') !== false ||
        strpos($line, 'خطأ في إنشاء حساب البنك') !== false ||
        strpos($line, 'bank') !== false && strpos($line, 'error') !== false
    ) {
        $bankErrors[] = $line;
    }
}

echo "Found " . count($bankErrors) . " bank-related error entries in the log:\n\n";

// Display the most recent errors first
$bankErrors = array_reverse($bankErrors);
foreach ($bankErrors as $index => $error) {
    echo "[$index] " . $error . "\n\n";

    // Only show the first 10 errors to avoid overwhelming output
    if ($index >= 9) {
        echo "... and " . (count($bankErrors) - 10) . " more errors\n";
        break;
    }
}
