<?php
require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/bootstrap/app.php';

$app = app();
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

// تحقق من القيد المحاسبي رقم 33
echo "Journal Entry 33 Details:\n";
$entry = \App\Models\JournalEntry::find(33);
if ($entry) {
    echo "ID: " . $entry->id . "\n";
    echo "Entry Number: " . $entry->entry_number . "\n";
    echo "Entry Date: " . $entry->entry_date . "\n";
    echo "Description: " . $entry->description . "\n";
    echo "Is Posted: " . ($entry->is_posted ? 'Yes' : 'No') . "\n";
    echo "Reference Type: " . $entry->reference_type . "\n";
    echo "Reference ID: " . $entry->reference_id . "\n";

    // تحقق من عناصر القيد المحاسبي
    echo "\nJournal Entry Items:\n";
    $items = \App\Models\JournalEntryItem::where('journal_entry_id', 33)->get();
    foreach ($items as $item) {
        $account = \App\Models\ChartOfAccount::find($item->account_id);
        echo "Account: " . ($account ? $account->name . " (" . $account->account_code . ")" : 'Unknown') . "\n";
        echo "Account Type: " . ($account ? $account->account_type . " / " . $account->sub_type : 'Unknown') . "\n";
        echo "Debit: " . $item->debit . "\n";
        echo "Credit: " . $item->credit . "\n\n";
    }
} else {
    echo "Journal Entry 33 not found\n";
}

// تحقق من العميل رقم 2
echo "\nCustomer 2 Details:\n";
$customer = \App\Models\Customer::find(2);
if ($customer) {
    echo "ID: " . $customer->id . "\n";
    echo "Name: " . $customer->name . "\n";
    echo "Name (EN): " . $customer->name_en . "\n";

    // تحقق من حساب العميل
    echo "\nCustomer Account:\n";
    $customerAccount = \App\Models\ChartOfAccount::where('sub_type', 'accounts_receivable')
        ->where(function ($query) use ($customer) {
            $query->where('account_code', 'AR-' . $customer->id)
                ->orWhere('name', 'like', '%' . $customer->name . '%')
                ->orWhere('name', 'like', '%' . $customer->name_en . '%');
        })
        ->first();

    if ($customerAccount) {
        echo "Account ID: " . $customerAccount->id . "\n";
        echo "Account Code: " . $customerAccount->account_code . "\n";
        echo "Account Name: " . $customerAccount->name . "\n";
    } else {
        echo "No account found for this customer\n";
    }

    // تحقق من كشف حساب العميل
    echo "\nCustomer Statements:\n";
    $statements = \App\Models\CustomerStatement::where('customer_id', 2)
        ->orderBy('transaction_date')
        ->get();

    if ($statements->count() > 0) {
        foreach ($statements as $stmt) {
            echo "ID: " . $stmt->id . "\n";
            echo "Date: " . $stmt->transaction_date . "\n";
            echo "Reference Type: " . $stmt->reference_type . "\n";
            echo "Reference ID: " . $stmt->reference_id . "\n";
            echo "Reference Number: " . $stmt->reference_number . "\n";
            echo "Description: " . $stmt->description . "\n";
            echo "Debit: " . $stmt->debit . "\n";
            echo "Credit: " . $stmt->credit . "\n";
            echo "Balance: " . $stmt->balance . "\n\n";
        }
    } else {
        echo "No statements found for this customer\n";
    }
} else {
    echo "Customer 2 not found\n";
}

// تحقق من سجلات كشف الحساب للقيد المحاسبي رقم 33
echo "\nStatements for Journal Entry 33:\n";
$journalEntryStatements = \App\Models\CustomerStatement::where('reference_type', 'App\Models\JournalEntry')
    ->where('reference_id', 33)
    ->get();

if ($journalEntryStatements->count() > 0) {
    foreach ($journalEntryStatements as $stmt) {
        echo "ID: " . $stmt->id . "\n";
        echo "Customer ID: " . $stmt->customer_id . "\n";
        echo "Date: " . $stmt->transaction_date . "\n";
        echo "Reference Number: " . $stmt->reference_number . "\n";
        echo "Description: " . $stmt->description . "\n";
        echo "Debit: " . $stmt->debit . "\n";
        echo "Credit: " . $stmt->credit . "\n";
        echo "Balance: " . $stmt->balance . "\n\n";
    }
} else {
    echo "No statements found for Journal Entry 33\n";
}
