<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use App\Models\JournalEntry;
use Illuminate\Support\Facades\DB;

echo "فحص توازن قيود اليومية...\n";

// الحصول على جميع قيود اليومية
$entries = JournalEntry::with('items')->get();
$unbalancedEntries = [];

foreach ($entries as $entry) {
    if (!$entry->isBalanced()) {
        $unbalancedEntries[] = [
            'id' => $entry->id,
            'entry_number' => $entry->entry_number,
            'entry_date' => $entry->entry_date,
            'description' => $entry->description,
            'total_debit' => $entry->total_debit,
            'total_credit' => $entry->total_credit,
            'difference' => abs($entry->total_debit - $entry->total_credit)
        ];
    }
}

if (count($unbalancedEntries) > 0) {
    echo "تم العثور على " . count($unbalancedEntries) . " قيد غير متوازن:\n";

    foreach ($unbalancedEntries as $entry) {
        echo "رقم القيد: " . $entry['entry_number'] . "\n";
        echo "التاريخ: " . $entry['entry_date'] . "\n";
        echo "الوصف: " . $entry['description'] . "\n";
        echo "إجمالي المدين: " . $entry['total_debit'] . "\n";
        echo "إجمالي الدائن: " . $entry['total_credit'] . "\n";
        echo "الفرق: " . $entry['difference'] . "\n";
        echo "-----------------------------------\n";
    }
} else {
    echo "جميع قيود اليومية متوازنة.\n";
}

// التحقق من أرصدة الحسابات
echo "\nفحص أرصدة الحسابات...\n";

$accounts = \App\Models\ChartOfAccount::all();
foreach ($accounts as $account) {
    // حساب الرصيد من بنود القيود المحاسبية
    $debits = $account->journalItems()->sum('debit');
    $credits = $account->journalItems()->sum('credit');

    // حساب الرصيد المتوقع
    $expectedBalance = 0;
    if (in_array($account->account_type, ['asset', 'expense'])) {
        $expectedBalance = $account->opening_balance + $debits - $credits;
    } else {
        $expectedBalance = $account->opening_balance + $credits - $debits;
    }

    // مقارنة الرصيد المتوقع بالرصيد الحالي
    if (abs($expectedBalance - $account->current_balance) > 0.01) {
        echo "حساب غير متوازن: " . $account->name . " (رمز: " . $account->account_code . ")\n";
        echo "الرصيد الحالي: " . $account->current_balance . "\n";
        echo "الرصيد المتوقع: " . $expectedBalance . "\n";
        echo "الفرق: " . abs($expectedBalance - $account->current_balance) . "\n";
        echo "-----------------------------------\n";
    }
}

echo "تم الانتهاء من الفحص.\n";
