<?php

// تحديد مسار التطبيق
$basePath = __DIR__;

// تحميل الملفات الأساسية
require $basePath . '/vendor/autoload.php';

// تحميل ملف البيئة
$app = require_once $basePath . '/bootstrap/app.php';

// تهيئة الكيرنل
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// البحث عن المستخدم manager3
$user = \App\Models\User::where('email', 'manager3@example.com')->first();

if (!$user) {
    echo "المستخدم غير موجود بالبريد الإلكتروني manager3@example.com\n";

    // البحث عن المستخدم بالـ ID
    $user = \App\Models\User::find(3);
    if ($user) {
        echo "تم العثور على المستخدم بالـ ID: 3\n";
        echo "البريد الإلكتروني: " . $user->email . "\n";
    } else {
        echo "لم يتم العثور على المستخدم بالـ ID: 3\n";

        // عرض قائمة المستخدمين
        echo "\nقائمة المستخدمين في النظام:\n";
        $users = \App\Models\User::all();
        foreach ($users as $u) {
            echo "ID: " . $u->id . " | الاسم: " . $u->name . " | البريد الإلكتروني: " . $u->email . "\n";
        }
        exit;
    }
}

echo "\nمعلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n";

// التحقق من صلاحيات وحدات المخزون
$permissions = [
    'view_inventory_units',
    'create_inventory_units',
    'edit_inventory_units',
    'delete_inventory_units',
    'view_inventory_item_units',
    'create_inventory_item_units',
    'edit_inventory_item_units',
    'delete_inventory_item_units',
];

echo "\nصلاحيات وحدات المخزون:\n";
foreach ($permissions as $permission) {
    echo "- $permission: " . ($user->hasPermission($permission) ? 'نعم' : 'لا') . "\n";

    // التحقق من وجود الصلاحية في قاعدة البيانات
    $permExists = \App\Models\Permission::where('slug', $permission)->exists();
    echo "  (الصلاحية موجودة في النظام: " . ($permExists ? 'نعم' : 'لا') . ")\n";

    // التحقق من وجود الصلاحية في جدول user_permission
    $userPermExists = \Illuminate\Support\Facades\DB::table('user_permission')
        ->where('user_id', $user->id)
        ->whereIn('permission_id', function ($query) use ($permission) {
            $query->select('id')->from('permissions')->where('slug', $permission);
        })
        ->exists();
    echo "  (الصلاحية موجودة في جدول user_permission: " . ($userPermExists ? 'نعم' : 'لا') . ")\n";
}

// التحقق من صلاحيات المخزون الأخرى
echo "\nصلاحيات المخزون الأخرى:\n";
$otherPermissions = [
    'view_warehouses',
    'view_inventory_items',
    'view_inventory_stock',
    'view_inventory_categories',
];

foreach ($otherPermissions as $permission) {
    echo "- $permission: " . ($user->hasPermission($permission) ? 'نعم' : 'لا') . "\n";
}

// التحقق من شرط ظهور قائمة المخزون
$inventoryCondition = $user->hasPermission('view_warehouses') ||
    $user->hasPermission('view_suppliers') ||
    $user->hasPermission('view_inventory_items') ||
    $user->hasPermission('view_inventory_stock') ||
    $user->hasPermission('view_inventory_units');

echo "\nهل يجب أن تظهر قائمة المخزون: " . ($inventoryCondition ? 'نعم' : 'لا') . "\n";

// إضافة الصلاحيات للمستخدم
echo "\nإضافة صلاحيات وحدات المخزون للمستخدم...\n";

foreach ($permissions as $permission) {
    $perm = \App\Models\Permission::where('slug', $permission)->first();
    if ($perm) {
        // التحقق من وجود الصلاحية مسبقاً
        $exists = \Illuminate\Support\Facades\DB::table('user_permission')
            ->where('user_id', $user->id)
            ->where('permission_id', $perm->id)
            ->exists();

        if (!$exists) {
            \Illuminate\Support\Facades\DB::table('user_permission')->insert([
                'user_id' => $user->id,
                'permission_id' => $perm->id,
                'granted' => 1,
                'expires_at' => null
            ]);
            echo "تمت إضافة صلاحية: $permission\n";
        } else {
            echo "الصلاحية موجودة مسبقاً: $permission\n";
        }
    } else {
        echo "الصلاحية غير موجودة في النظام: $permission\n";
    }
}

// التحقق مرة أخرى بعد الإضافة
echo "\nالتحقق من الصلاحيات بعد الإضافة:\n";
foreach ($permissions as $permission) {
    // تنظيف ذاكرة التخزين المؤقت للمستخدم
    \Illuminate\Support\Facades\Cache::forget('user_permissions_' . $user->id);

    echo "- $permission: " . ($user->hasPermission($permission) ? 'نعم' : 'لا') . "\n";
}

echo "\nتم الانتهاء من التحقق وإضافة الصلاحيات\n";
