<?php

// تحديد مسار التطبيق
$basePath = __DIR__;

// تحميل الملفات الأساسية
require $basePath . '/vendor/autoload.php';

// تحميل ملف البيئة
$app = require_once $basePath . '/bootstrap/app.php';

// تهيئة الكيرنل
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

// البحث عن المستخدم
$user = \App\Models\User::find(3);

if (!$user) {
    echo "لم يتم العثور على المستخدم\n";
    exit;
}

echo "معلومات المستخدم:\n";
echo "الاسم: " . $user->name . "\n";
echo "البريد الإلكتروني: " . $user->email . "\n\n";

// التحقق من شرط ظهور قائمة المخزون
$inventoryCondition = $user->hasPermission('view_warehouses') ||
    $user->hasPermission('view_suppliers') ||
    $user->hasPermission('view_inventory_items') ||
    $user->hasPermission('view_inventory_stock') ||
    $user->hasPermission('view_inventory_units');

echo "هل يجب أن تظهر قائمة المخزون: " . ($inventoryCondition ? 'نعم' : 'لا') . "\n\n";

// إضافة صلاحية view_warehouses للمستخدم
echo "إضافة صلاحية view_warehouses للمستخدم...\n";
$warehousesPerm = \App\Models\Permission::where('slug', 'view_warehouses')->first();
if ($warehousesPerm) {
    $exists = \Illuminate\Support\Facades\DB::table('user_permission')
        ->where('user_id', $user->id)
        ->where('permission_id', $warehousesPerm->id)
        ->exists();

    if (!$exists) {
        \Illuminate\Support\Facades\DB::table('user_permission')->insert([
            'user_id' => $user->id,
            'permission_id' => $warehousesPerm->id,
            'granted' => 1,
            'expires_at' => null
        ]);
        echo "تمت إضافة صلاحية: view_warehouses\n";
    } else {
        echo "الصلاحية موجودة مسبقاً: view_warehouses\n";
    }
} else {
    echo "الصلاحية غير موجودة في النظام: view_warehouses\n";
}

// تنظيف ذاكرة التخزين المؤقت للمستخدم
\Illuminate\Support\Facades\Cache::forget('user_permissions_' . $user->id);

// التحقق مرة أخرى بعد الإضافة
$inventoryCondition = $user->hasPermission('view_warehouses') ||
    $user->hasPermission('view_suppliers') ||
    $user->hasPermission('view_inventory_items') ||
    $user->hasPermission('view_inventory_stock') ||
    $user->hasPermission('view_inventory_units');

echo "\nهل يجب أن تظهر قائمة المخزون بعد الإضافة: " . ($inventoryCondition ? 'نعم' : 'لا') . "\n";

// التحقق من صلاحيات وحدات المخزون
echo "\nصلاحيات وحدات المخزون:\n";
$permissions = [
    'view_inventory_units',
    'view_inventory_item_units',
    'view_warehouses'
];

foreach ($permissions as $permission) {
    echo "- $permission: " . ($user->hasPermission($permission) ? 'نعم' : 'لا') . "\n";
}

echo "\nتم الانتهاء من التحقق\n";
