<?php
require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // البحث عن المستخدم
    $user = \App\Models\User::where('email', 'fany@fany.com')->first();
    if (!$user) {
        echo "لم يتم العثور على المستخدم fany@fany.com\n";
        exit(1);
    }

    echo "معلومات المستخدم:\n";
    echo "الاسم: " . $user->name . "\n";
    echo "البريد الإلكتروني: " . $user->email . "\n";
    echo "الحالة: " . ($user->is_active ? 'نشط' : 'غير نشط') . "\n\n";

    echo "الأدوار:\n";
    foreach ($user->roles as $role) {
        echo "- " . $role->name . " (" . $role->slug . ")\n";
    }

    echo "\nالصلاحيات المباشرة للمستخدم:\n";
    $directPermissions = $user->permissions;
    if ($directPermissions->count() > 0) {
        foreach ($directPermissions as $perm) {
            echo "- " . $perm->name . " (" . $perm->slug . ")\n";
        }
    } else {
        echo "لا توجد صلاحيات مباشرة للمستخدم\n";
    }

    echo "\nجميع الصلاحيات المتاحة للمستخدم (من خلال الأدوار والصلاحيات المباشرة):\n";
    $allPermissions = $user->getAllPermissions();
    echo "عدد الصلاحيات: " . $allPermissions->count() . "\n";

    // عرض صلاحيات الصيانة فقط
    echo "\nصلاحيات الصيانة المتاحة للمستخدم:\n";
    $maintenancePermissions = $allPermissions->filter(function ($perm) {
        return strpos($perm->slug, 'maintenance') !== false;
    });

    if ($maintenancePermissions->count() > 0) {
        foreach ($maintenancePermissions as $perm) {
            echo "- " . $perm->name . " (" . $perm->slug . ")\n";
        }
    } else {
        echo "لا توجد صلاحيات صيانة متاحة للمستخدم\n";
    }
} catch (\Exception $e) {
    echo "حدث خطأ: " . $e->getMessage() . "\n";
    echo "في الملف: " . $e->getFile() . " على السطر: " . $e->getLine() . "\n";
}
