<?php

// Cargar la aplicación
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Obtener todos los registros de journal entries
$entries = \App\Models\JournalEntry::all();
echo "Total de registros encontrados: " . $entries->count() . "\n\n";

foreach ($entries as $entry) {
    echo "ID: " . $entry->id . "\n";
    echo "Número: " . $entry->entry_number . "\n";
    echo "Fecha: " . $entry->entry_date . "\n";
    echo "Publicado: " . ($entry->is_posted ? "Sí" : "No") . "\n";
    echo "Descripción: " . $entry->description . "\n";

    // Verificar si tiene un registro en customer_statements
    $statements = \App\Models\CustomerStatement::where('reference_type', 'App\\Models\\JournalEntry')
        ->where('reference_id', $entry->id)
        ->get();

    echo "Registros en customer_statements: " . $statements->count() . "\n";

    if ($statements->count() > 0) {
        foreach ($statements as $statement) {
            echo "  - Statement ID: " . $statement->id . ", Cliente: " . $statement->customer_id . ", Debit: " . $statement->debit . ", Credit: " . $statement->credit . ", Balance: " . $statement->balance . "\n";
        }
    }

    echo "----------------------------------------\n";
}
