<?php
require_once __DIR__ . '/vendor/autoload.php';

use App\Models\Bank;
use App\Models\ChartOfAccount;
use Illuminate\Support\Facades\DB;

// Initialize Laravel application
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

try {
    // Check for duplicate bank names
    $duplicateBanks = DB::table('banks')
        ->select('name', DB::raw('COUNT(*) as count'))
        ->groupBy('name')
        ->having('count', '>', 1)
        ->get();

    echo "Duplicate bank names:\n";
    if ($duplicateBanks->count() > 0) {
        foreach ($duplicateBanks as $bank) {
            echo "- {$bank->name}: {$bank->count} occurrences\n";
        }
    } else {
        echo "No duplicate bank names found.\n";
    }

    // Check for duplicate account codes in chart of accounts
    $duplicateAccounts = DB::table('chart_of_accounts')
        ->select('account_code', DB::raw('COUNT(*) as count'))
        ->groupBy('account_code')
        ->having('count', '>', 1)
        ->get();

    echo "\nDuplicate account codes in chart of accounts:\n";
    if ($duplicateAccounts->count() > 0) {
        foreach ($duplicateAccounts as $account) {
            echo "- {$account->account_code}: {$account->count} occurrences\n";

            // Show details of accounts with this code
            $accounts = ChartOfAccount::where('account_code', $account->account_code)->get();
            foreach ($accounts as $acc) {
                echo "  * ID: {$acc->id}, Name: {$acc->name}, Company ID: {$acc->company_id}\n";
            }
        }
    } else {
        echo "No duplicate account codes found.\n";
    }

    // Check for unique constraints in the database
    $uniqueConstraints = DB::select("
        SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME
        FROM information_schema.KEY_COLUMN_USAGE
        WHERE TABLE_SCHEMA = 'elevators_management'
        AND TABLE_NAME IN ('banks', 'chart_of_accounts')
        AND CONSTRAINT_NAME LIKE '%unique%'
    ");

    echo "\nUnique constraints on banks and chart_of_accounts tables:\n";
    foreach ($uniqueConstraints as $constraint) {
        echo "- {$constraint->TABLE_NAME}: {$constraint->CONSTRAINT_NAME} on column {$constraint->COLUMN_NAME}\n";
    }

    // Check for any bank accounts that might be causing issues
    $bankAccounts = ChartOfAccount::where('is_bank_account', true)->get();

    echo "\nExisting bank accounts in chart of accounts:\n";
    foreach ($bankAccounts as $account) {
        echo "- ID: {$account->id}, Code: {$account->account_code}, Name: {$account->name}, Is Parent: " . ($account->is_parent ? 'Yes' : 'No') . ", Company ID: {$account->company_id}\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
