<?php
require_once __DIR__ . '/vendor/autoload.php';

// Initialize Laravel application
$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

try {
    // Check chart_of_accounts table structure
    echo "Chart of Accounts Table Structure:\n";
    $columns = Schema::getColumnListing('chart_of_accounts');
    foreach ($columns as $column) {
        $type = DB::select("SHOW COLUMNS FROM chart_of_accounts WHERE Field = ?", [$column])[0]->Type;
        echo "- $column: $type\n";
    }

    // Check indexes on chart_of_accounts
    echo "\nChart of Accounts Indexes:\n";
    $indexes = DB::select("SHOW INDEXES FROM chart_of_accounts");
    $indexGroups = [];
    foreach ($indexes as $index) {
        $name = $index->Key_name;
        if (!isset($indexGroups[$name])) {
            $indexGroups[$name] = [
                'name' => $name,
                'unique' => $index->Non_unique == 0 ? 'UNIQUE' : 'INDEX',
                'columns' => []
            ];
        }
        $indexGroups[$name]['columns'][] = $index->Column_name;
    }

    foreach ($indexGroups as $index) {
        echo "- {$index['name']} ({$index['unique']}): " . implode(', ', $index['columns']) . "\n";
    }

    // Check for soft-deleted BANK accounts
    echo "\nSoft-deleted BANK accounts:\n";
    $softDeletedBanks = DB::select("
        SELECT * FROM chart_of_accounts 
        WHERE account_code = 'BANK' 
        AND deleted_at IS NOT NULL
    ");

    if (count($softDeletedBanks) > 0) {
        foreach ($softDeletedBanks as $bank) {
            echo "- ID: {$bank->id}, Company ID: {$bank->company_id}, Name: {$bank->name}, Deleted At: {$bank->deleted_at}\n";
        }
    } else {
        echo "No soft-deleted BANK accounts found.\n";
    }

    // Check for active BANK accounts
    echo "\nActive BANK accounts:\n";
    $activeBanks = DB::select("
        SELECT * FROM chart_of_accounts 
        WHERE account_code = 'BANK' 
        AND deleted_at IS NULL
    ");

    if (count($activeBanks) > 0) {
        foreach ($activeBanks as $bank) {
            echo "- ID: {$bank->id}, Company ID: {$bank->company_id}, Name: {$bank->name}\n";
        }
    } else {
        echo "No active BANK accounts found.\n";
    }

    // Check for bank accounts with BANK- prefix
    echo "\nBank accounts with BANK- prefix:\n";
    $bankAccounts = DB::select("
        SELECT * FROM chart_of_accounts 
        WHERE account_code LIKE 'BANK-%' 
        AND deleted_at IS NULL
    ");

    if (count($bankAccounts) > 0) {
        foreach ($bankAccounts as $bank) {
            echo "- ID: {$bank->id}, Company ID: {$bank->company_id}, Code: {$bank->account_code}, Name: {$bank->name}\n";
        }
    } else {
        echo "No bank accounts with BANK- prefix found.\n";
    }
} catch (\Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
